<?php
   //incluimos la clase phplot
   include_once("phplot.php");

   //valor de inicio del eje x
   $inicio=$_POST["x_ini"];

   //valor final del eje x
   $final=$_POST["x_fin"];

   //numero de puntos a evaluar
   $evalua=$_POST["evalua"];

   //Incremento en cada paso. 
   //Lo obtenemos dividiendo la amplitud del intervalo
   //entre el nmero de puntos a evaluar
   //No se controla su valor
   $paso=($final-$inicio)/$evalua;

   //Parmetros de la parbola. No se testea el valor 
   //de a, si es cero se pintar una recta
   $a=$_POST["a"];
   $b=$_POST["b"];
   $c=$_POST["c"];

   //Valor inicial del contador
   $i=$inicio;

   //Definimos el array que contiene los valores a representar
   //el formato de cada dato es (etiqueta,x,y)
   while ($i<=$final){
      $datos=array("",$i,$a*$i*$i+$b*$i+$c);
      $data[]=$datos;
      $i=$i+$paso;
   }
	
   //Creamos una instancia de la clase PHPlot
   $grafico = new PHPlot;

   //Tipo de datos con los que se trabaja
   $grafico->SetDataType("data-data");

   //Ttulo del grfico
   //es mejorable el formato de salida
   $grafico->SetTitle("Grfica de y=(".$a.")x^2+(".$b.")x+(".$c.")");

   //Tipo del grfico, en este caso "lines": une 
   //los puntos con una lnea
   $grafico->SetPlotType("lines");

   //Grosor de la lnea
   $grafico->SetLineWidth(3);

   //Longitud de las rayitas de los ejes en pxel
   $grafico->SetTickLength(1);

   //Incremento del eje y
   //En este ejemplo no lo usamos y dejamos que lo
   //represente de forma automtica
   //$grafico->SetVertTickIncrement(10);

   //Incremento del eje X
   //En este caso numeramos el eje X de uno en uno
   //a partir del valor inicial
   $grafico->SetHorizTickIncrement(1);

   //Etiquetas de los ejes
   $grafico->SetXLabel("Eje X");
   $grafico->SetYLabel("Eje Y");

   //Pasamos a PHPlot los datos del grfico
   $grafico->SetDataValues($data);

   //Abre la grfica en el navegador Web
   $grafico->DrawGraph();

?>
